/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.TextComponent;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;

public class FadeText
extends TextComponent {
    private long messagetime;
    private String message = "";

    public FadeText(Font f, Color c, Point center) {
        super(f, c, center);
    }

    public void setText(String msg, long time) {
        this.message = msg;
        this.messagetime = System.currentTimeMillis() + time;
    }

    public void draw(Graphics g, long time) {
        long now = System.currentTimeMillis();
        if (this.messagetime > now) {
            int diff = (int)((this.messagetime - now) / 10L);
            Color color = this.getColor();
            if (diff >= color.getAlpha()) {
                g.setColor(color);
            } else {
                g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), diff));
            }
            Font font = this.getFont();
            g.setFont(font);
            FontMetrics fm2 = g.getFontMetrics(font);
            int textlen = fm2.stringWidth(this.message);
            g.drawString(this.message, this.getX() - textlen + (textlen >> 1), this.getY() - fm2.getHeight());
        }
    }
}

