/*
 * Decompiled with CFR 0.152.
 */
package engine;

import components.StaticText;
import engine.Receiver;
import game.cstrike.Game;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public class Spectator
extends Applet
implements Runnable {
    private volatile Thread thread;
    private Receiver receiver;
    private Image buffer;
    private Game game;
    private StaticText errorMsg;
    private StaticText rateMsg;
    private int myX;
    private int myY;
    private Image scaled;
    private int scaleMethod;
    private double scale;
    static final int FRAME_RATE = 6;
    static final int WIDTH = 1024;
    static final int HEIGHT = 768;

    public final int getOrgWidth() {
        return 1024;
    }

    public final int getOrgHeight() {
        return 768;
    }

    public void init() {
        Color bgcolor = null;
        try {
            bgcolor = new Color(Integer.parseInt(super.getParameter("bgcolor"), 16));
            this.scaleMethod = Integer.parseInt(super.getParameter("resample"));
            this.scale = Double.parseDouble(super.getParameter("scale")) / 100.0;
            this.myX = (int)(1024.0 * this.scale);
            this.myY = (int)(768.0 * this.scale);
        }
        catch (Exception e) {
            this.scaleMethod = 1;
            this.scale = 1.0;
            this.myX = 1024;
            this.myY = 768;
            bgcolor = new Color(0x3C3C3C);
        }
        this.errorMsg = new StaticText(new Font("Dialog", 1, 16), new Color(200, 200, 200), new Point(20, 30));
        this.setBackground(bgcolor);
        this.scaled = this.buffer = this.createImage(1024, 768);
        this.game = new Game(this, this.errorMsg);
        this.rateMsg = new StaticText(new Font("Dialog", 0, 12), new Color(200, 100, 0), new Point(965, 750));
        this.rateMsg.setText("???B/s");
        this.receiver = new Receiver(this, this.game, this.errorMsg, this.rateMsg);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.receiver.terminate();
        this.terminate();
    }

    public void run() {
        int frame = 0;
        long lastdraw = 0L;
        while (this.thread == Thread.currentThread()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Graphics g = this.buffer.getGraphics();
            this.game.view.draw(g, ++frame);
            this.rateMsg.draw(g, frame);
            if (!this.errorMsg.isEmpty()) {
                this.errorMsg.draw(g, frame);
            }
            this.scaled = this.scale != 1.0 ? this.buffer.getScaledInstance(this.myX, this.myY, this.scaleMethod) : this.buffer;
            this.repaint();
        }
    }

    public void terminate() {
        this.thread = null;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        g.drawImage(this.scaled, 0, 0, this);
    }

    public int getScaledWidth() {
        return this.myX;
    }

    public int getScaledHeight() {
        return this.myY;
    }
}

