/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.TextComponent;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class ChatBox
extends TextComponent {
    private Vector chatText;
    private Color bgColor;
    private int rowsNum;
    private long chatTime;
    private int currentWidth;
    private boolean calculateWidth;
    private long delay;
    private boolean m_visible;

    public ChatBox(Font f, Color c, Point p, Color b, int rows, long de) {
        super(f, c, p);
        this.chatText = new Vector(rows);
        this.bgColor = b;
        this.delay = de;
        this.rowsNum = rows;
        this.calculateWidth = false;
        this.m_visible = true;
    }

    public boolean isVisible() {
        return this.m_visible;
    }

    public void setVisible(boolean v) {
        this.m_visible = v;
    }

    public final Color getBackground() {
        return this.bgColor;
    }

    public void add(String msg) {
        if (this.chatText.size() >= this.rowsNum) {
            this.chatText.remove(0);
        }
        this.chatText.add(msg);
        long now = System.currentTimeMillis();
        if (this.chatTime < now) {
            this.chatTime = now + this.delay;
        }
        this.calculateWidth = true;
    }

    public void draw(Graphics g, long time) {
        if (this.chatText.isEmpty()) {
            this.currentWidth = 0;
            return;
        }
        long now = System.currentTimeMillis();
        if (this.chatTime < now) {
            this.chatText.remove(0);
            this.chatTime = now + this.delay;
            if (this.chatText.isEmpty()) {
                return;
            }
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.calculateWidth) {
            this.calculateWidth = false;
            int a = 0;
            while (a < this.chatText.size()) {
                int w = this.calculateTextArea((String)((String)this.chatText.get((int)a)), (Graphics)g).width;
                if (w > this.currentWidth) {
                    this.currentWidth = w;
                }
                ++a;
            }
        }
        FontMetrics fm = g.getFontMetrics(this.getFont());
        int height = fm.getHeight();
        int asc = fm.getAscent();
        int des = fm.getDescent();
        int boxheight = height * this.chatText.size();
        g.setColor(this.bgColor);
        g.fillRect(this.getX() - des, this.getY() - asc, this.currentWidth, boxheight);
        g.setColor(Color.BLACK);
        g.drawRect(this.getX() - des, this.getY() - asc, this.currentWidth, boxheight);
        g.setColor(this.getColor());
        g.setFont(this.getFont());
        int a = 0;
        while (a < this.chatText.size()) {
            g.drawString((String)this.chatText.get(a), this.getX(), this.getY() + a * height);
            ++a;
        }
    }
}

