/*
 * Decompiled with CFR 0.152.
 */
package components.cstrike;

import components.ItemView;
import components.cstrike.PlayerViewInfo;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PlayerView
extends ItemView {
    private static final Color selectColor = new Color(50, 250, 50, 220);
    private static final Color infoColor = new Color(50, 250, 50, 220);
    boolean selected;
    PlayerViewInfo player;
    private int pulse;

    public PlayerView(PlayerViewInfo pp) {
        super(pp);
        this.player = pp;
    }

    public void setSelected(boolean s) {
        this.selected = s;
    }

    public Rectangle getBounds() {
        Point org = this.player.getOrigin(0L);
        return new Rectangle(org.x - 12, org.y - 12, 24, 24);
    }

    public void draw(Graphics g, long time) {
        if (!this.player.isVisible()) {
            return;
        }
        Point dd = this.player.getOrigin(time);
        if (!this.player.isState(16)) {
            g.setColor(this.player.getLookColor(time));
            g.fillArc(dd.x - 45, dd.y - 45, 90, 90, this.player.getAngle(time), 90);
            if (this.player.isState(1)) {
                g.setColor(this.player.getTeamColor());
                this.pulse = (this.pulse + 1) % 30 + 20;
                int half = this.pulse >> 1;
                g.drawOval(dd.x - half, dd.y - half, this.pulse, this.pulse);
            }
        }
        super.draw(g, time);
        if (this.selected) {
            g.setColor(this.player.getTeamColor());
            g.drawOval(dd.x - 12, dd.y - 12, 24, 24);
        }
        String txt = this.player.getName();
        FontMetrics fm = g.getFontMetrics();
        int len = fm.stringWidth(txt);
        g.setColor(infoColor);
        g.drawString(txt, dd.x - len + (len >> 1), dd.y + 24);
    }
}

