/*
 * Decompiled with CFR 0.152.
 */
package game.cstrike;

import components.LiveTextInfo;
import components.cstrike.PlayerViewInfo;
import game.Look;
import game.cstrike.Game;
import java.awt.Color;
import java.awt.Point;

public class Player
extends game.Player
implements LiveTextInfo,
PlayerViewInfo {
    public static final byte ATTACKING = 1;
    public static final byte INJURED = 2;
    public static final byte ALIVE = 4;
    public static final byte DEAD = 8;
    public static final byte DYING = 16;
    public static final byte FLY = 32;
    public static final byte DISCONNECTED = 64;
    public static final byte SPECTATING = -128;
    public static final byte BOMB = 1;
    public static final byte BUYZONE = 2;
    public static final byte FLASHLIGHT = 4;
    public static final byte DEFUSER = 8;
    private static final Color radColor = new Color(0, 250, 0, 40);
    private static final Color defColor = new Color(50, 100, 250);
    private int kills;
    private int deaths;
    private byte state;
    private Game game;
    private long angleframe;
    private long moveframe;
    protected boolean hasbomb;
    private int icons;

    public void setIcons(int a) {
        this.icons = a;
    }

    public boolean isIcon(int a) {
        return (this.icons & a) != 0;
    }

    public void setState(byte a) {
        this.state = a;
    }

    public void setDeaths(int a) {
        this.deaths = a;
    }

    public void setKills(int a) {
        this.kills = a;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public int getKills() {
        return this.kills;
    }

    public Player(Game g) {
        super(g);
        this.game = g;
    }

    public String getLiveTextData() {
        if (this.isState(4) && !this.isState(16)) {
            return "Name: " + this.getName() + ", Health: " + this.getHealth() + ", Weapon: " + this.game.getWeaponName(this.getWeapon());
        }
        return null;
    }

    public String getText() {
        return null;
    }

    public int getAngle(long time) {
        if (time != this.angleframe) {
            this.look.doMove();
        }
        this.angleframe = time;
        return Look.normalize((short)this.game.map.getAngle(this.look.getLook()));
    }

    public Point getOrigin(long time) {
        if (time != this.moveframe) {
            this.walk.doMove();
        }
        this.moveframe = time;
        Point x = this.walk.getWalk();
        return this.game.map.getOrigin(x.x, x.y);
    }

    public boolean isState(int a) {
        return (this.state & a) != 0;
    }

    public Color getColor(long frame) {
        if (this.isState(16) && !this.isState(32)) {
            return this.game.getTeamColor(0);
        }
        if (this.isState(2) && frame % 2L == 0L) {
            return this.game.getTeamColor(0);
        }
        if (this.isIcon(8)) {
            return defColor;
        }
        if (this.isIcon(1)) {
            return this.game.bomb.getColor(0L);
        }
        return this.game.getTeamColor(this.getTeam());
    }

    public Color getLookColor(long time) {
        return radColor;
    }

    public boolean isVisible() {
        if (this.isState(16)) {
            return true;
        }
        return !this.isState(8) && !this.isState(32) && !this.isState(64) && !this.isState(-128) && this.isState(4);
    }

    public Color getDeadColor() {
        return this.game.getTeamColor(0);
    }

    public Color getTeamColor() {
        return this.game.getTeamColor(this.getTeam());
    }

    public int getSize() {
        return 16;
    }
}

