/*
 * Decompiled with CFR 0.152.
 */
package network;

import network.Packet;

public abstract class ChunkPacket {
    protected byte[] m_body;
    private int m_pos;
    private byte m_hdr;
    private Packet m_pck;

    public ChunkPacket(Packet pck) {
        this.m_pck = pck;
        this.m_body = pck.getData();
        this.m_pos = pck.getOffset();
        this.m_hdr = this.readByte();
    }

    protected byte[] getData() {
        return this.m_body;
    }

    protected int getOffset() {
        return this.m_pck.getOffset();
    }

    public final byte getHeader() {
        return this.m_hdr;
    }

    public final int readInteger() {
        int result = 0;
        result |= 0xFF000000 & this.m_body[this.m_pos++] << 24;
        result |= 0xFF0000 & this.m_body[this.m_pos++] << 16;
        result |= 0xFF00 & this.m_body[this.m_pos++] << 8;
        this.m_pck.setOffset(this.m_pos);
        return result |= 0xFF & this.m_body[this.m_pos++] << 0;
    }

    public final short readShort() {
        short result = (short)(this.m_body[this.m_pos++] << 8 & 0xFF00);
        result = (short)(result | (short)(0xFF & this.m_body[this.m_pos++]));
        this.m_pck.setOffset(this.m_pos);
        return result;
    }

    public final byte readByte() {
        byte result = this.m_body[this.m_pos++];
        this.m_pck.setOffset(this.m_pos);
        return result;
    }

    public final String readString() {
        byte length = this.m_body[this.m_pos++];
        int start = this.m_pos;
        this.m_pos += length;
        this.m_pck.setOffset(this.m_pos);
        return new String(this.m_body, start, (int)length);
    }
}

